% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdc.R
\docType{data}
\name{setHDclassif.show}
\alias{setHDclassif.show}
\alias{getHDclassif.show}
\title{Sets/gets the default 'show' argument in HDDC and HDDA}
\format{
An object of class \code{function} of length 1.
}
\usage{
setHDclassif.show(show)

getHDclassif.show
}
\arguments{
\item{show}{Single logical with default. Will specify the default value of the \code{show} argument in HDDA and HDDC.}
}
\value{
\code{getHDclassif.show} returns the default value.
}
\description{
Sets/gets the default value for 'show' argument in HDDC and HDDC. When \code{TRUE} then clustering information is returned at the end of the process.
}
\examples{

data(Crabs)

# clustering of the Crabs dataset:
prms <- hddc(Crabs[,-1], K=4)  
# By default no information is displayed

# To show information:
prms <- hddc(Crabs[,-1], K=4, show = TRUE)  

# To set it permanently:
setHDclassif.show(TRUE)
prms <- hddc(Crabs[,-1], K=4)  

# to disable it permanently:
setHDclassif.show(FALSE)




}
\keyword{datasets}
