% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/urtest.R
\name{UR_test}
\alias{UR_test}
\title{Testing for unit roots based on sample autocovariances}
\usage{
UR_test(Y, lagk.vec = NULL, con_vec = NULL, alpha = 0.05)
}
\arguments{
\item{Y}{A vector \eqn{{\bf Y} = (Y_1, \dots , Y_n )'}, where \eqn{n} is the number
of the observations.}

\item{lagk.vec}{The time lag \eqn{K_0} used to calculate the test statistic
[See Section 2.1 of Chang, Cheng and Yao (2022)]. It can be a vector specifying
multiple time lags. If provided as a \eqn{s \times 1} vector, the function will
output the test results corresponding to each of the \eqn{s} values in \code{lagk.vec}.
The default is \code{c(0, 1, 2, 3, 4)}.}

\item{con_vec}{The constant \eqn{c_\kappa} specified in (5) of
Chang, Cheng and Yao (2022). The default is 0.55. Alternatively, it can be an
\eqn{m \times 1} vector specified by users, representing \eqn{m} candidate values
of \eqn{c_\kappa}.}

\item{alpha}{The significance level of the test. The default is 0.05.}
}
\value{
An object of class \code{"urtest"}, which contains the following
  components:

  \item{statistic}{A \eqn{s \times 1} vector with each element representing
  the test statistic value associated with each of the \eqn{s} time lags specified
  in \code{lagk.vec}.}
  \item{reject}{An \eqn{m \times s} data matrix \eqn{{\bf R}=(R_{i,j})} where
  \eqn{R_{i,j}} represents whether the null hypothesis \eqn{H_0} should be rejected
  for \eqn{c_\kappa} specified by the \eqn{i}-th component of \code{con_vec},
  and \eqn{K_0} specified by the \eqn{j}-th component of \code{lagk.vec}.
  \eqn{R_{i,j}=1} indicates rejection of the null hypothesis,
   while \eqn{R_{i,j}=0} indicates non-rejection.}
  \item{lag.vec}{The time lags used in function.}
}
\description{
This function implements the test proposed in Chang, Cheng and Yao (2022)
for the following hypothesis testing problem:
\deqn{H_0:Y_t \sim I(0)\ \ \mathrm{versus}\ \ H_1:Y_t \sim
I(d)\ \mathrm{for\ some\ integer\ }d \geq 1\,,} where \eqn{Y_t} is
a univariate time series.
}
\examples{
# Example 1
## Generate yt
N <- 100
Y <-arima.sim(list(ar = c(0.9)), n = 2*N, sd = sqrt(1))
con_vec <- c(0.45, 0.55, 0.65)
lagk.vec <- c(0, 1, 2)

UR_test(Y, lagk.vec = lagk.vec, con_vec = con_vec, alpha = 0.05)
UR_test(Y, alpha = 0.05)
}
\references{
Chang, J., Cheng, G., & Yao, Q. (2022). Testing for unit
  roots based on sample autocovariances. \emph{Biometrika}, \strong{109},
  543--550. \doi{doi:10.1093/biomet/asab034}.
}
