% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ccsr.R
\name{download_ccsr}
\alias{download_ccsr}
\title{Download CCSR Mapping Files from HCUP}
\usage{
download_ccsr(
  type = "diagnosis",
  version = "latest",
  cache = TRUE,
  clean_names = TRUE
)
}
\arguments{
\item{type}{Character string specifying the type of CCSR file to download.
Must be one of: "diagnosis" (or "dx") for ICD-10-CM diagnosis codes, or
"procedure" (or "pr") for ICD-10-PCS procedure codes. Default is "diagnosis".}

\item{version}{Character string specifying the CCSR version to download.
Use "latest" to download the most recent version, or specify a version
like "v2026.1", "v2025.1", etc. Default is "latest".}

\item{cache}{Logical. If TRUE (default), the downloaded file is cached in
a temporary directory to avoid re-downloading on subsequent calls.}

\item{clean_names}{Logical. If TRUE (default), column names are cleaned to
follow R naming conventions (snake_case).}
}
\value{
A tibble containing the CCSR mapping data with the following columns:
\itemize{
\item For diagnosis files: ICD-10-CM code, CCSR category, default CCSR category,
and clinical descriptions
\item For procedure files: ICD-10-PCS code, CCSR category, and descriptions
}
}
\description{
Downloads and loads Clinical Classifications Software Refined (CCSR) mapping
files directly from the Agency for Healthcare Research and Quality (AHRQ)
Healthcare Cost and Utilization Project (HCUP) website.
}
\details{
This function downloads CCSR mapping files directly from the HCUP website.
The package does not redistribute these files but facilitates access to the
official AHRQ data sources.

The function handles:
\itemize{
\item Automatic URL construction based on type and version
\item ZIP file download and extraction
\item Proper encoding of special characters
\item Preservation of leading zeros in ICD-10 codes
\item Conversion to tidy tibble format
}
}
\examples{
\donttest{
# Download latest diagnosis CCSR mapping
dx_map <- download_ccsr("diagnosis")

# Download specific version of procedure CCSR mapping
pr_map <- download_ccsr("procedure", version = "v2025.1")

# Download without caching
dx_map <- download_ccsr("diagnosis", cache = FALSE)
}

}
