% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_num_pages.R
\name{get_num_pages}
\alias{get_num_pages}
\title{Get Number of Pages from Goodreads}
\usage{
get_num_pages(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the number of pages for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the number of pages for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)
# Run the function
num_pages <- get_num_pages(temp_file)
print(num_pages)
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
