% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapfun.R
\name{bootstrapfun}
\alias{bootstrapfun}
\title{Function to perform parametric bootstrap}
\usage{
bootstrapfun(mu, sigma, Q, max_iter, prec, n)
}
\arguments{
\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{Q}{transition probability matrix (r x r);}

\item{max_iter}{maximum number of iterations of the EM algorithm; suggestion 10 000;}

\item{prec}{precision (stopping criteria); suggestion 0.0001;}

\item{n}{length of the time series.}
}
\value{
\item{f}{values of the density function at time n+k}

\item{w}{weights of the mixture}
}
\description{
This function simulates the data under the  null hypothesis of a Gaussian HMM
and compute the Cramér-von Mises test statistic.
}
\examples{
mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05); Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2) ;
out <- bootstrapfun(mu,sigma,Q,max_iter=10000,prec=0.0001,n=100)

}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
\keyword{internal}
