% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GofHMM1d.R
\name{GofHMM1d}
\alias{GofHMM1d}
\title{Goodness-of-fit test of a univariate Gaussian Hidden Markov Model}
\usage{
GofHMM1d(y, reg, max_iter = 10000, eps = 1e-04, n_sample = 1000, n_cores)
}
\arguments{
\item{y}{(n x 1) data vector}

\item{reg}{number of regimes}

\item{max_iter}{maxmimum number of iterations of the EM algorithm; suggestion 10 000}

\item{eps}{eps (stopping criteria); suggestion 0.0001}

\item{n_sample}{number of bootstrap samples; suggestion 1000}

\item{n_cores}{number of cores to use in the parallel computing}
}
\value{
\item{pvalue}{pvalue of the Cram\'er-von Mises statistic in percent}

\item{mu}{estimated mean for each regime}

\item{sigma}{estimated standard deviation for each regime}

\item{Q}{(reg x reg) estimated transition matrix}

\item{eta}{(n x reg) conditional probabilities of being in regime k at time t given observations up to time t}

\item{lambda}{(n x reg) probabilities of being in regime k at time t given all observations}

\item{cvm}{Cramér-von Mises statistic for the goodness-of-fit test}

\item{W}{Pseudo-observations that should be uniformly distributed under the null hypothesis of a Gaussian HMM}

\item{LL}{Log-likelihood}
}
\description{
This function performs a goodness-of-fit test of a Gaussian HMM based on a Cramér-von Mises statistic
using parametric bootstrap.
}
\examples{
\donttest{
Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2); mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05)
data <- Sim.HMM.Gaussian.1d(mu,sigma,Q,eta0=1,100)$x
gof <- GofHMM1d(data, 2, max_iter=10000, eps=0.0001, n_sample=100,n_cores=2)
}
}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
