% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nip.rcag.R
\name{nip.rcag}
\alias{nip.rcag}
\title{Proportion of Non-Intersecting Arc Pairs in an RCAG.}
\usage{
nip.rcag(s, t, e1, e2)
}
\arguments{
\item{s}{Start points of arcs.}

\item{t}{End points of arcs.}

\item{e1}{Vector of indices for the first interval in each pair.}

\item{e2}{Vector of indices for the second interval in each pair.}
}
\value{
Mean proportion of non-intersecting pairs.
}
\description{
Computes the proportion of non-intersecting pairs of arcs in the RCAG obtained using data.
}
\examples{
s <- circular::rcircularuniform(10) 
t <- circular::rcircularuniform(10)
e1 <- c(2,10,6,1,5)
e2 <- c(4,3,8,7,9)
nip.rcag(s,t,e1,e2)
}
