% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{detail_plot}
\alias{detail_plot}
\title{Create Comprehensive Bar Charts from HAR and SL4 Data}
\usage{
detail_plot(
  data,
  filter_var = NULL,
  x_axis_from,
  split_by = "Variable",
  panel_var = "Experiment",
  variable_col = "Variable",
  unit_col = "Unit",
  desc_col = "Description",
  invert_axis = TRUE,
  separate_figure = FALSE,
  top_impact = NULL,
  var_name_by_description = FALSE,
  add_var_info = FALSE,
  output_path = NULL,
  export_picture = TRUE,
  export_as_pdf = FALSE,
  export_config = NULL,
  plot_style_config = NULL
)
}
\arguments{
\item{data}{A data frame or list of data frames containing GTAP results.}

\item{filter_var}{NULL, a vector, a data frame, or a named list specifying filtering conditions.
For example: \code{list(Variable = c("EV", "qgdp"), REG = c("USA", "THA"))}.}

\item{x_axis_from}{Character. Column name used for the x-axis.}

\item{split_by}{Character or vector.
\itemize{
\item Column(s) used to split plots by (e.g., \code{"REG"} or \code{c("COMM", "REG")}).
\item If \code{NULL}, a single aggregated plot is generated.
}}

\item{panel_var}{Character. Column for panel facets. Default is \code{"Experiment"}.}

\item{variable_col}{Character. Column name for variable codes. Default is \code{"Variable"}.}

\item{unit_col}{Character. Column name for units. Default is \code{"Unit"}.}

\item{desc_col}{Character. Column name for variable descriptions. Default is \code{"Description"}.

\strong{Plot Behavior}}

\item{invert_axis}{Logical. If \code{TRUE}, flips the plot orientation (horizontal bars). Default is \code{FALSE}.}

\item{separate_figure}{Logical. If \code{TRUE}, generates a separate plot for each value in \code{panel_var}. Default is \code{FALSE}.}

\item{top_impact}{Numeric or NULL. If specified, shows only the top N impactful values; \code{NULL} shows all.

\strong{Variable Display}}

\item{var_name_by_description}{Logical. If \code{TRUE}, uses descriptions instead of variable codes in titles. Default is \code{FALSE}.}

\item{add_var_info}{Logical. If \code{TRUE}, appends variable codes in parentheses after the description. Default is \code{FALSE}.

\strong{Export Settings}}

\item{output_path}{Character. Directory to save plots. If \code{NULL}, plots are returned but not saved.}

\item{export_picture}{Logical. If \code{TRUE}, exports plots as PNG images. Default is \code{TRUE}.}

\item{export_as_pdf}{Logical or \code{"merged"}.
\itemize{
\item \code{FALSE} (default): disables PDF export.
\item \code{TRUE}: exports each plot as a separate PDF file.
\item \code{"merged"}: combines all plots into a single PDF file.
}}

\item{export_config}{List. Export options including dimensions, DPI, and background.
See \code{\link{create_export_config}} or \code{\link{get_all_config}}.

\strong{Styling}}

\item{plot_style_config}{List. Custom plot appearance settings.
See \code{\link{create_plot_style}} or \code{\link{get_all_config}}.}
}
\value{
A ggplot object or a named list of ggplot objects depending on the \code{separate_figure} setting.
If \code{export_picture} or \code{export_as_pdf} is enabled, the plots are also saved to \code{output_path}.
}
\description{
Generates detailed bar charts to visualize the distribution of impacts across multiple dimensions.
Supports top impact filtering, color coding, and fully customizable styling and export options.

\strong{Input Data}
}
\examples{
# Load Data:
input_path <- system.file("extdata/in", package = "GTAPViz")
sl4.plot.data <- readRDS(file.path(input_path, "sl4.plot.data.rds"))

# Prepare Dataframe
sector_data <- sl4.plot.data[["COMM*REG"]]

# Plot
plotB <- detail_plot(
  # === Input Data ===
  data        = sector_data,
  filter_var  = list(Region = "Oceania"),
  x_axis_from = "Commodity",
  split_by    = "Region",
  panel_var   = "Experiment",
  variable_col = "Variable",
  unit_col     = "Unit",
  desc_col     = "Description",

  # === Plot Behavior ===
  invert_axis      = TRUE,
  separate_figure  = FALSE,
  top_impact       = NULL,

  # === Variable Display ===
  var_name_by_description = TRUE,
  add_var_info            = FALSE,

  # === Export Settings ===
  output_path     = NULL,
  export_picture  = FALSE,
  export_as_pdf   = FALSE,
  export_config   = create_export_config(width = 45, height = 20),

  # === Styling ===
  plot_style_config = create_plot_style(
    positive_color = "#2E8B57",
    negative_color = "#CD5C5C",
    panel_rows = 1,
    panel_cols = NULL,
    show_axis_titles_on_all_facets = FALSE,
    y_axis_text_size = 25,
    bar_width = 0.6,
    all_font_size = 1.1
  )
)
}
\seealso{
\code{\link{comparison_plot}}, \code{\link{stack_plot}}
}
\author{
Pattawee Puangchit
}
