% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRM_IBD.R
\name{getPairwiseIBD}
\alias{getPairwiseIBD}
\title{Calculate Pairwise IBD (Identity By Descent)}
\usage{
getPairwiseIBD(
  PlinkPrefix,
  SparseGRMFile,
  PairwiseIBDOutput,
  frqFile = NULL,
  tempDir = NULL,
  maxSampleNums = 2500,
  minMafIBD = 0.01,
  rm.tempFile = FALSE
)
}
\arguments{
\item{PlinkPrefix}{Character. Path to PLINK file (without file extensions .bed/.bim/.fam).}

\item{SparseGRMFile}{Character. Path to sparse GRM file from getSparseGRM() function.}

\item{PairwiseIBDOutput}{Character. Output path to save pairwise IBD results.}

\item{frqFile}{Character. Path to frequency file corresponding to PLINK file.
If NULL (default), uses PlinkPrefix.frq.}

\item{tempDir}{Character. Directory to save temporary files. If NULL (default), uses tempdir().}

\item{maxSampleNums}{Integer. Maximum number of subjects' genotypes to read for analysis (default: 2500).}

\item{minMafIBD}{Numeric. Minimum MAF cutoff to select markers (default: 0.01).}

\item{rm.tempFile}{Logical. Whether to delete temporary files (default: FALSE).}
}
\value{
Character. Message indicating where the pairwise IBD results have been stored.
}
\description{
This function calculates pairwise IBD probabilities for related samples using
PLINK genotype data and sparse GRM. It follows the getSparseGRM() function workflow.
}
\examples{
PlinkPrefix <- file.path(system.file(package = "GRAB"), "extdata", "simuPLINK")
SparseGRMFile <- system.file("extdata", "SparseGRM.txt", package = "GRAB")
PairwiseIBDOutput <- file.path(tempdir(), "PairwiseIBD.txt")
getPairwiseIBD(PlinkPrefix, SparseGRMFile, PairwiseIBDOutput)

}
