% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_accuracy.R
\name{flex_accuracy}
\alias{flex_accuracy}
\title{flex_accuracy function}
\usage{
flex_accuracy(
  accuracy_data,
  conf_level = 0.95,
  display_CI = TRUE,
  interactive = TRUE,
  user_colors = NULL,
  display_p_values = TRUE,
  Models_to_display_p_values = NULL,
  user_title = "Prediction Accuracy Plot",
  user_x_title = "Model",
  user_y_title = "Prediction Accuracy",
  user_legend_title = NULL,
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_text(size = 10), legend.text =
    element_text(size = 15), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  user_p_value_prefix = NULL,
  user_bar_width = 0.8,
  geom_text_args = list(),
  additional_ggplot_args = list()
)
}
\arguments{
\item{accuracy_data}{A data frame containing four columns: 'Model' (factor or
character vector of Model names), 'R_squared' (numeric vector of prediction
accuracies), 'p_value' (numeric vector of p-values) and 'se' (numeric vector
of standard errors of prediction accuracies).}

\item{conf_level}{A numeric value between 0 and 1 to indicate level of
confidence; default is 0.95.}

\item{display_CI}{Logical; if TRUE, returns confidence intervals (CIs).}

\item{interactive}{Logical; if TRUE, returns an interactive Plotly plot. If
FALSE, returns a static ggplot object.}

\item{user_colors}{Optional; a vector of colors to use for the bars. If NULL,
default ggplot2 colors are used.}

\item{display_p_values}{Logical; if TRUE, p-values are displayed on the plot.}

\item{Models_to_display_p_values}{Optional; a vector of Model names for which
to display p-values. If NULL, p-values are displayed for all Models.}

\item{user_title}{Character string setting the title of the plot.}

\item{user_x_title}{Character string for the x-axis title.}

\item{user_y_title}{Character string for the y-axis title.}

\item{user_legend_title}{Optional; character string for the legend title. If
NULL, the legend is hidden.}

\item{user_plot_theme}{ggplot2 theme object to use for the base styling of
the plot.}

\item{user_plot_theme_specs}{ggplot2 theme object to apply additional
styling.}

\item{user_p_value_prefix}{Optional; character string to prefix before
p-values in their annotations.}

\item{user_bar_width}{Numeric value for the width of the bars in the plot.}

\item{geom_text_args}{List of additional arguments to pass to geom_text for
p-value annotation customization.}

\item{additional_ggplot_args}{List of additional ggplot objects to add to the
plot.}
}
\value{
A ggplot object if 'interactive' is FALSE; otherwise, an interactive
Plotly plot.
}
\description{
Creates a bar plot of Model prediction accuracies with the option to display
p-values and make the plot interactive using Plotly.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Usage with default bar width
flex_accuracy(example_data3)
# Example to show only specific Models' p-values with thicker bars
flex_accuracy(example_data3, display_p_values = TRUE, Models_to_display_p_values = 
c("Model A", "Model E"), user_bar_width = 0.8)
# Optionally add p-value annotations
flex_accuracy(example_data3, user_p_value_prefix = "p = ", geom_text_args = 
list(data = example_data3, fontface = "bold", hjust = 0.5, color = "darkblue", 
size = 3))
#adding additional plotting features
flex_accuracy(example_data3, user_bar_width = 0.5, display_p_values = TRUE, 
Models_to_display_p_values = c("Model A", "Model E"),
             geom_text_args = list(data = subset(example_data3, 
             Model \%in\% c("Model A", "Model E")), angle = 60, 
             fontface = "bold", hjust = 0.5, color = "darkblue", size = 5), 
             additional_ggplot_args = list(ggplot2::scale_y_continuous(limits = c(0, 1.3))))
# Adjust the geom_text_args to nudge p-value annotations above the bars
flex_accuracy(example_data3,
             user_bar_width = 0.5,
             display_p_values = TRUE,
             Models_to_display_p_values = c("Model A", "Model E"),
             geom_text_args = list(angle = 60, fontface = "bold", hjust = 1, 
             color = "darkblue", size = 5,
                                   nudge_y = 0.2),  
             additional_ggplot_args = list(ggplot2::scale_y_continuous(limits = c(0, 1.5))))
}
