% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_hotspots.r
\name{rMatClustlpp}
\alias{rMatClustlpp}
\title{Simulating the Matern cluster process on a linear network}
\usage{
rMatClustlpp(Centers, R, alpha, LL, check_vol = FALSE)
}
\arguments{
\item{Centers}{The (x,y)-coordinates of parent points}

\item{R}{Cluster radius parameter of the Matern cluster process.}

\item{alpha}{Parameter related to mean number of points per cluster.}

\item{LL}{The linear network on which the point pattern should be simulated.}

\item{check_vol}{Logical. TRUE for checking if the ball producing the cluster
has any intersection with linear network.}
}
\description{
Simulating the Matern clusters with parameters alpha and R given the (x,y)-
coordinates of the parent points.
This function is provided in \pkg{GET} to support
\code{\link{hotspots.MatClustlpp}}. See the hotspots vignette available
by starting R, typing \code{library("GET")} and \code{vignette("GET")}.
}
