% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.R
\name{BIC}
\alias{BIC}
\title{BIC for GARCHX model}
\usage{
BIC(model)
}
\arguments{
\item{model}{GARCHX object}
}
\value{
BIC of GARCHX model
}
\description{
Calculates the Bayesian Information Criterion of the GARCHX model
}
\examples{
set.seed(123)
pi <- c(1, 0, 0, 4)
n <- 2000
d <- length(pi)
valinit <- 100
n2 <- n + d + 1
omega <- 0.1
alpha <- 0.2
beta <- 0.3
delta <- 2
e<-rnorm(n2+valinit)
Y<-e
for (t in 2:n2)
 Y[t]<- 0.2*Y[t-1]+e[t]
x<-exp(Y)
X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
for(j in 1:d)
 X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
data <- GARCH.X::simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
model <- GARCHX_select(eps = data$eps, X = data$X)
BIC_value <- BIC(model)
}
