#' Predict GARCHX future time series values
#'
#' Predicts values for GARCHX model
#'
#' @param model GARCHX object
#' @param X Exogenous covariates for predictions
#' @param n_pred Number of predictions into the future
#'
#' @return Vector of predicted time series data
#'
#' @references
#' Francq, C. and Thieu, L.Q.(2018). *QML Inference for Volatility Models with Covariates*.
#' Econometric Theory, Cambridge University Press
#'
#' @export
#'
#' @examples set.seed(123)
#' @examples pi <- c(1, 0, 0, 4)
#' @examples n <- 2000
#' @examples d <- length(pi)
#' @examples valinit <- 100
#' @examples n2 <- n + d + 1
#' @examples omega <- 0.1
#' @examples alpha <- 0.2
#' @examples beta <- 0.3
#' @examples delta <- 2
#' @examples e<-rnorm(n2+valinit)
#' @examples Y<-e
#' @examples for (t in 2:n2)
#' @examples  Y[t]<- 0.2*Y[t-1]+e[t]
#' @examples x<-exp(Y)
#' @examples X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
#' @examples for(j in 1:d)
#' @examples  X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
#' @examples data <- GARCHX::simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
#' @examples model <- GARCHX_select(eps = data$eps, X = data$X)
#' @examples n_pred = 10
#' @examples test.X <- data$X[(n-n_pred+1):n, ]
#' @examples predictions <- predict(model = model, X = test.X, n_pred = n_pred)
#'
predict <- function(model, X, n_pred){
  UseMethod("predict")
} # End predict
