% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSTestCriticalValue.R
\name{KSTestCriticalValue}
\alias{KSTestCriticalValue}
\title{A simple wrapper to provide the p-value for the K-S one- and two-sample test.}
\usage{
KSTestCriticalValue(criticalValue, n1, n2)
}
\arguments{
\item{criticalValue}{Critical value for the one- or two-sample K-S test.}

\item{n1}{Size of the first sample.}

\item{n2}{Size of the second sample (or NA for the case of the one-sample test).}
}
\value{
The output is given as a real number equal to the p-value for the one- or two-sample
K-S test.
}
\description{
`KSTestCriticalValue` calculates the p-value for the given critical value,
based on the respective function from the \code{stats} package.
}
\details{
The function calculates the p-value for the one- and two-sample Kolmogorov-Smirnov test
using the respective function from the \code{stats} package.
The necessary information is the critical value given by \code{criticalValue} parameter,
and the sizes of one or two samples (parameters \code{n1, n2}, respectively).
The output is used in one of the epistemic bootstrap methods if the one- or two-sample K-S test is applied.
}
\examples{

# find p-value for the critical value 0.3 and two samples of size 10

KSTestCriticalValue(0.3,10,10)

}
