% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_design_initial_MLM.R
\name{EW_design_initial_MLM}
\alias{EW_design_initial_MLM}
\title{function to generate a initial EW Design for multinomial logistic models}
\usage{
EW_design_initial_MLM(
  k.continuous,
  factor.level,
  xlist_fix = NULL,
  lvec,
  uvec,
  bvec_matrix,
  h.func,
  link = "continuation",
  EW_Fi.func = EW_Fi_MLM_func,
  delta0 = 1e-06,
  epsilon = 1e-12,
  maxit = 1000
)
}
\arguments{
\item{k.continuous}{number of continuous variables}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{lvec}{lower limit of continuous variables}

\item{uvec}{upper limit of continuous variables}

\item{bvec_matrix}{the matrix of the sampled parameter values of beta}

\item{h.func}{function, is used to transfer the design point to model matrix (e.g. add interaction term, add intercept)}

\item{link}{link function, default "continuation", other options "baseline", "adjacent" and "cumulative"}

\item{EW_Fi.func}{function, is used to calculate the Expectation of Fisher information for a design point - default to be EW_Fi_MLM_func() in the package}

\item{delta0}{tuning parameter, the distance threshold, || x_i(0) - x_j(0) || >= delta0}

\item{epsilon}{determining f.det > 0 numerically, f.det <= epsilon will be considered as f.det <= 0}

\item{maxit}{maximum number of iterations}
}
\value{
X        matrix of initial design point

p0       initial random approximate allocation

f.det    the determinant of the expected Fisher information matrix for the initial design.
}
\description{
function to generate a initial EW Design for multinomial logistic models
}
\examples{
k.continuous.temp=1
link.temp = "continuation"
n.factor.temp = c(0)
factor.level.temp = list(c(80,200))
hfunc.temp = function(y){
matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3, ncol=5, byrow=TRUE)
}
lvec.temp = 80
uvec.temp = 200
bvec_bootstrap<-matrix(c(-0.2401, -1.9292, -2.7851, -1.614,-1.162,
                         -0.0535, -0.0274, -0.0096,-0.0291, -0.04,
                          0.0004,  0.0003,  0.0002,  0.0003,  0.1,
                         -9.2154, -9.7576, -9.6818, -8.5139, -8.56),nrow=4,byrow=TRUE)
EW_design_initial_MLM(k.continuous=k.continuous.temp, factor.level=n.factor.temp,xlist_fix=NULL,
lvec=lvec.temp,uvec=uvec.temp, bvec_matrix=bvec_bootstrap, h.func=hfunc.temp, link=link.temp)
}
