% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_Xw_maineffects_self.R
\name{EW_Xw_maineffects_self}
\alias{EW_Xw_maineffects_self}
\title{function for calculating X=h(x) and E_w=E(nu(beta^T h(x))) given a design point x=(1,x1,...,xd)^T}
\usage{
EW_Xw_maineffects_self(
  x,
  Integral_based,
  joint_Func_b,
  Lowerbounds,
  Upperbounds,
  b_matrix,
  link = "logit",
  h.func = NULL
)
}
\arguments{
\item{x}{x=(x1,...,xd) -- design point/experimental setting}

\item{Integral_based}{TRUE or FALSE, if TRUE then we will find the integral-based EW D-optimality otherwise we will find the sample-based EW D-optimality}

\item{joint_Func_b}{prior distribution function of model parameters}

\item{Lowerbounds}{vector of lower ends of ranges of prior distribution for model parameters.}

\item{Upperbounds}{vector of upper ends of ranges of prior distribution for model parameters.}

\item{b_matrix}{matrix of bootstrapped or simulated parameter values.}

\item{link}{link = "logit"  -- link function, default: "logit", other links: "probit", "cloglog", "loglog", "cauchit", "log"}

\item{h.func}{function h(x)=(h1(x),...,hp(x)), default (1,x1,...,xd)}
}
\value{
X=h(x)=(h1(x),...,hp(x)) -- a row for design matrix

E_w -- E(nu(b^t h(x)))

link -- link function applied
}
\description{
function for calculating X=h(x) and E_w=E(nu(beta^T h(x))) given a design point x=(1,x1,...,xd)^T
}
\examples{
hfunc.temp = function(y) {c(y,1);};   # y -> h(y)=(y1,y2,y3,1)
link.temp="logit"
paras_lowerbound<-rep(-Inf, 4)
paras_upperbound<-rep(Inf, 4)
gjoint_b<- function(x) {
mu1 <- -0.5; sigma1 <- 1
mu2 <- 0.5; sigma2 <- 1
mu3 <- 1; sigma3 <- 1
mu0 <- 1; sigma0 <- 1
d1 <- stats::dnorm(x[1], mean = mu1, sd = sigma1)
d2 <- stats::dnorm(x[2], mean = mu2, sd = sigma2)
d3 <- stats::dnorm(x[3], mean = mu3, sd = sigma3)
d4 <- stats::dnorm(x[4], mean = mu0, sd = sigma0)
return(d1 * d2 * d3 * d4)
}
x.temp = c(2,1,3)
EW_Xw_maineffects_self(x=x.temp,Integral_based=TRUE,joint_Func_b=gjoint_b,
Lowerbounds=paras_lowerbound,Upperbounds=paras_upperbound, link=link.temp,
h.func=hfunc.temp)
}
