% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit_functions.R
\name{FactorHet_refit}
\alias{FactorHet_refit}
\title{Refit model using estimated sparsity patterns}
\usage{
FactorHet_refit(
  object,
  newdata,
  tolerance = 0.001,
  hard_assign = FALSE,
  iter_refit = 200
)
}
\arguments{
\item{object}{An object from \code{\link{FactorHet}} or
\code{\link{FactorHet_mbo}}.}

\item{newdata}{A data.frame containing the data to be estimated in the refit
model.}

\item{tolerance}{A numerical value that sets the threshold at which to
declare two levels as "fused"; the default is 1e-3. Two levels meet this
threshold if the maximum difference between the main effects and any
interactions is \code{tolerance}.}

\item{hard_assign}{A logical value that sets whether observations should be
be assigned to the most probable cluster given \eqn{\phi} from the original
model or whether they should they be weighted according to their estimated
group membership probabilities, \eqn{\hat{\pi}(X_i)}. The default is
\code{FALSE} which uses the weighted method.}

\item{iter_refit}{An integer value that sets the number of iterations used in
fitting the refit model. The default is 200. A warning will be produced if
it does not converge in this many iterations.}
}
\value{
An object of class \code{\link{FactorHet}} that contains the output
  described the linked documentation.
}
\description{
Using a previously estimated model, this function takes the
  estimated sparsity patterns (e.g., which levels are fused together) and the
  estimates of the moderator parameters, \eqn{\hat{\phi}}, and re-estimates the
  regression parameters \eqn{\beta}.
}
\details{
The main use of this function is to enable sample-splitting as
  discussed in Goplerud et al. (2025) to improve coverage and remove bias
  from the initial estimates. An example is provided below.
}
\examples{
data(immigration)
set.seed(1)
# Split the data into two parts for sample-splitting
train_data <- subset(immigration, CaseID < 900)
refit_data <- subset(immigration, CaseID >= 900)
# Fit using fixed lambda for demonstration
# only
fit <- FactorHet(Chosen_Immigrant ~ Plans + Ed + Country,
  design = train_data, lambda = 1e-2,
  moderator = ~ party_ID + census_div,
  control = FactorHet_control(init = 'mclust'),
  K = 2, group = ~ CaseID, task = ~ contest_no, choice_order = ~ choice_id)
# Refit using the other half of data
\donttest{
refit <- FactorHet_refit(fit, newdat = refit_data)
# AME (etc.) for treatment effects can be computed as normal
AME_refit <- AME(refit)
# As can heterogeneous effects, although uncertainty in 
# phi is ignored
HTE_refit <- HTE_by_individual(refit, AME_refit, design = immigration)
}
}
