% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_functions.R, R/standard_error_functions.R
\name{FactorHet-class}
\alias{FactorHet-class}
\alias{plot.FactorHet}
\alias{formula.FactorHet}
\alias{print.FactorHet}
\alias{summary.FactorHet}
\alias{coef.FactorHet}
\alias{logLik.FactorHet}
\alias{BIC.FactorHet}
\alias{AIC.FactorHet}
\alias{print.FactorHet_vis}
\alias{visualize_MBO}
\alias{posterior_FactorHet}
\alias{vcov.FactorHet}
\title{Generic methods for FactorHet models}
\usage{
\method{plot}{FactorHet}(x, y = NULL, ...)

\method{formula}{FactorHet}(x, ...)

\method{print}{FactorHet}(x, fusion.tolerance = 0.001, ...)

\method{summary}{FactorHet}(object, show_interactions = FALSE, digits = 3, ...)

\method{coef}{FactorHet}(object, coef_type = "beta", ...)

\method{logLik}{FactorHet}(object, type = "loglik", ...)

\method{BIC}{FactorHet}(object, ...)

\method{AIC}{FactorHet}(object, ...)

\method{print}{FactorHet_vis}(x, ...)

visualize_MBO(object)

posterior_FactorHet(object)

\method{vcov}{FactorHet}(object, phi = TRUE, se.method = NULL, ...)
}
\arguments{
\item{x}{Model from FactorHet}

\item{y}{Not used; required to maintain compatibility.}

\item{...}{Optional arguments; only used by \code{plot.FactorHet} with
\code{\link{cjoint_plot}}.}

\item{fusion.tolerance}{Threshold at which to declare levels fused}

\item{object}{Object fit using \code{\link{FactorHet}} or \code{\link{FactorHet_mbo}}.}

\item{show_interactions}{Used by \code{summary.FactorHet}; indicates whether the
interaction terms be shown. Default \code{FALSE}. See "Details" for more
discussion.}

\item{digits}{Number of digits to include}

\item{coef_type}{Type of coefficient (beta for treatment effects; phi for moderators)}

\item{type}{For "logLik", should the log-likelihood (\code{"loglik"}),
log-posterior (\code{"log_posterior"}), or sequence of log-posterior values
at each iteration (\code{"log_posterior_seq"}) be returned?}

\item{phi}{A logical value indicating whether the standard errors from the
moderator parameters, \eqn{\phi}, should be returned as well. The default
is \code{TRUE}.}

\item{se.method}{A string value for the type of standard errors to be
computed. The default, and primary option, is \code{NULL} which is
generally equivalent to \code{"louis"} (Louis 1982), as discussed in Goplerud et al.
(2025).}
}
\value{
Returns the corresponding output of the generic method. "Details"
  provides details on the output of each function.
}
\description{
Brief descriptions of generic methods (e.g. print, summary) for FactorHet as
well as a way to visualize the progress of the model-based optimization.
}
\details{
The following methods with the arguments given above exist. All
  methods work on models with using \code{\link{FactorHet}} and
  \code{\link{FactorHet_mbo}}. 
  \describe{
  \item{plot: }{This is a shorthand for \code{\link{cjoint_plot}} on a fitted
  object.}
  \item{formula: }{This returns the underlying formula for the treatment effects and
  moderators as a named list. This also returns the values used for \code{group},
  \code{task}, and \code{choice_order} if provided.}
  \item{print: }{This consists of two \code{print} methods.
  For \code{\link{FactorHet}}, it summarizes the
  model and fusion of the factor levels. \code{fusion.tolerance} sets the
  threshold at which levels are reported as fused. For outputs of
  \code{\link{AME}} (and similar), this plots the corresponding plot. See
  that documentation for more details.}
  \item{summary: }{This summarizes the main effects by group with standard
  errors. It is typically more common to visualize this with
  \code{\link{cjoint_plot}} (and the accompanying data.frame) or \code{\link{AME}}.
  \code{show_interactions = TRUE} shows the interactions in addition to the
  main effects.}
  \item{coef: }{This returns the coefficient matrix on the original scale (i.e.
  with the sum-to-zero constraints). \code{code_type = "phi"} returns the
  moderator coefficients instead of the treatment effect coefficients.}
  \item{AIC and BIC: }{This returns the AIC or BIC. If multiple degrees of
  freedom options specified, it returns a matrix.}
  \item{logLik: }{This returns the log-likelihood, log-posterior or sequence of
  log-posterior values at each iteration of the algorithm. The argument
  \code{"type"} provides more details.}
  \item{visualize_MBO: }{For a model fit with \code{\link{FactorHet_mbo}}, 
  this shows information about the MBO, i.e. proposed values and objectives.}
  \item{posterior_FactorHet: }{For a model with \code{K > 1}, this visualizes 
  the posterior for each observation and the posterior predictive implied by 
  the moderators.}
  \item{vcov.FactorHet}{This extracts the estimated variance-covariance 
  matrix of the parameters.}
 }
}
\references{
Louis, Thomas A. 1982. "Finding the Observed Information Matrix when Using
  the EM Algorithm." \emph{Journal of the Royal Statistical Society. Series B
  (Methodological)}. 44(2):226-233.
  
  Goplerud, Max, Kosuke Imai, and Nicole E. Pashley. 2025. "Estimating
  Heterogeneous Causal Effects of High-Dimensional Treatments: Application to
  Conjoint Analysis." arxiv preprint: \url{https://arxiv.org/abs/2201.01357}
}
