% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irdc_simple.R
\name{irdc_simple}
\alias{irdc_simple}
\title{Simple Estimator of the Integrated R-squared Dependence Coefficient (irdc_simple) for 1 Dimensional continuous X and Y}
\usage{
irdc_simple(Y, X, na.rm = TRUE)
}
\arguments{
\item{Y}{A vector of length n.}

\item{X}{A vector of length n.}

\item{na.rm}{Logical; if TRUE, missing values (NAs) will be removed. Default is TRUE.}
}
\value{
The Simple Integrated R-squared Dependence Coefficient (irdc_simple) between Y and X.
}
\description{
The Simple Integrated R-squared Dependence Coefficient (irdc_simple) is a measure of dependence between
a continuous random variables Y and X, based on an i.i.d. sample of (Y, X).
The estimated coefficient is asymptotically guaranteed to lie between 0 and 1.
The measure is asymmetrical; that is, irdc_simple(X, Y) != irdc_simple(Y, X).
The measure equals 0 if and only if X is independent of Y, and it equals 1 if and only if
Y is a measurable function of X.
This coefficient has several applications; for example, it can be used for independence test.
This coefficient only implemented for the 1-Dimensional continuous random variable X and Y.
}
\details{
The value returned by `irdc_simple` can be positive or negative for finite samples,
but asymptotically, it is guaranteed to be between 0 and 1.
A small value indicates low dependence between Y and X, while a high value indicates strong dependence.
The `irdc_simple` function is used for testing the independence of variables.
}
\examples{
n = 1000
x <- matrix(runif(n * 3), nrow = n)
y <- (x[, 1] + x[, 2])
irdc_simple(y, x[, 1])
irdc_simple(y, x[, 2])
irdc_simple(y, x[, 3])
}
\references{
Azadkia, M. and Roudaki, P. (2025). A New Measure Of Dependence: Integrated R2
\url{http://arxiv.org/abs/2505.18146}.
}
\seealso{
\code{\link{irdc}}, \code{\link[FOCI]{codec}}, \code{\link[XICOR]{xicor}}, \code{\link[KPC]{KPCgraph}}, \code{\link[KPC]{KPCRKHS}}
}
\author{
Mona Azadkia, Pouya Roudaki
}
