% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AP_assay_simulator.R
\name{AP_assay_simulator}
\alias{AP_assay_simulator}
\title{Main function for AP assay simulation}
\usage{
AP_assay_simulator(
  assayinput_in,
  fixedComponent_in,
  WF_in,
  smarkpams_in,
  isVerbose = 0,
  virusTypeIn
)
}
\arguments{
\item{assayinput_in}{Numeric array with 3 rows (required): \code{[1,]} assay variable durations, \code{[2,]} reps per duration, \code{[3,]} zero entries for infected test plants (to be populated with simulated values).}

\item{fixedComponent_in}{Numeric vector of 3 fixed durations in the order AAP, LAP, IAP; nb. one of these 3 will not be relevant for the sub-assay as it is varied in the assay (code -1) e.g. if AAP sub-assay \code{[1]} is -1, if LAP sub-assay \code{[2]} is -1, if IAP sub-assay \code{[3]} is -1 (required).}

\item{WF_in}{Number of insect vectors in cohort (required).}

\item{smarkpams_in}{Numeric vector: 4 elements representing virus rate parameters (hr^-1) (required):
\code{[1]}, acquisition rate;
\code{[2]}, inoculation rate;
\code{[3]}, latent progression rate WITH code -1 for SPT (no significant latency for SPT virus);
\code{[4]}, insect recovery rate.}

\item{isVerbose}{Binary (optional, default = 0). If 1, prints information from nested functions.}

\item{virusTypeIn}{Character. Plant virus type, either \code{"SPT"} or \code{"PT"}  (required).}
}
\value{
A numeric array with 3 rows corresponding to assay structure and outcome:
The first row specifies the assay variable durations,
the second the reps per duration,
the third the simulated number of infected test plants.
}
\description{
This function simulates the assay data of an AP experiment (calling the helper function AP_insect_simulator.r to simulate on a per insect basis).
}
\examples{
assay1=AP_assay_simulator(
  assayinput_in=rbind(c(6,7,8),rep(10,3),rep(0,3)),
  fixedComponent_in=c(10,-1,10),WF_in=5,
  smarkpams_in=rep(0.1,4),isVerbose=0,virusTypeIn='PT'
)
}
