% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_var_summary.R
\name{ec_var_summary}
\alias{ec_var_summary}
\title{A Summary Table of Final Cleaned Spatial and Environmental Variables}
\usage{
ec_var_summary(
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude",
  env_layers
)
}
\arguments{
\item{data}{data table after cleaning the records}

\item{latitude}{default set to "decimalLatitude"}

\item{longitude}{default set to "decimalLongitude"}

\item{env_layers}{an array of col names of enviornmental layers}
}
\value{
A summary table with the mean, min and max values of final cleaned spatial and environmental variables
}
\description{
A Summary Table of Final Cleaned Spatial and Environmental Variables
}
\examples{
data <- data.frame(
  scientificName = "Mexacanthina lugubris",
  decimalLongitude = c(-117, -117.8, -116.9, -116.5),
  decimalLatitude = c(32.9, 33.5, 31.9, 32.4),
  BO_sstmean = c(12, 13, 14, 11),
  BO_sstmin = c(9, 6, 10, 10),
  BO_sstmax = c(14, 16, 18, 17)
)
env_layers <- c("BO_sstmean", "BO_sstmin", "BO_sstmax")
ec_var_summary(data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude",
  env_layers
)

}
