% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{saveDataText}
\alias{saveDataText}
\title{Save elisa_batch analysis results}
\usage{
saveDataText(batches, file.name)
}
\arguments{
\item{batches}{list of elisa batch data to be serialized.}

\item{file.name}{character specifying name of the output file.}
}
\description{
Save the data analysis results to disk in text format.
}
\details{
The results are written to disk in the text format (tab-delimited) and is 
easy to be used for other analysis.
}
\examples{
#'#R code to run 5-parameter logistic regression on ELISA data
#load the library
library(ELISAtools)

#get file folder
dir_file<-system.file("extdata", package="ELISAtools")

batches<-loadData(file.path(dir_file,"design.txt"))

#make a guess for the parameters, the other two parameters a and d 
#will be estimated based on data.
model<-"5pl"
pars<-c(7.2,0.5, 0.015) #5pl inits
names(pars)<-c("xmid", "scal", "g")


#do fitting. model will be written into data set.
batches<-runFit(pars=pars,  batches=batches, refBatch.ID=1, model=model  )

#now call to do predications based on the model.
batches<-predictAll(batches);

#now saving the data in text.
saveDataText(batches, file.path(tempdir(),"elisa_data.txt"));


}
