% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictionIntervals.R
\name{makeAnnualPI}
\alias{makeAnnualPI}
\title{Make Annual Prediction Intervals}
\usage{
makeAnnualPI(dailyBootOut, eList, paLong = 12, paStart = 10,
  fluxUnit = 3)
}
\arguments{
\item{dailyBootOut}{data frame returned from \code{\link{genDailyBoot}}}

\item{eList}{named list with at least the Daily, Sample, and INFO 
dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{paLong}{numeric integer specifying the length of the period of analysis, in months, 1<=paLong<=12, default is 12}

\item{paStart}{numeric integer specifying the starting month for the period of analysis, 1<=paStart<=12, default is 10}

\item{fluxUnit}{number representing entry in pre-defined fluxUnit class array. 
\code{\link[EGRET]{printFluxUnitCheatSheet}}}
}
\value{
a list of 2 data frames, one for average concentration, in mg/L
and one for flux (unit depends on fluxUnit argument)
In each data frame the first column is DecYear. The remaining columns are
quantiles of the flux or concentration (depending on the data frame).
}
\description{
This function takes the output from \code{\link{genDailyBoot}} and 
calculates the quantiles for an annual (based on paStart/paLong) aggregation. 
This means that the function can be used for seasons.
}
\examples{
eList <- EGRET::Choptank_eList
# This example is only based on 4 iterations
# Actual prediction intervals should be calculated on
# a much larger number of iterations (several hundred).  
dailyBoot <- Choptank_dailyBootOut
annualPcts <- makeAnnualPI(dailyBoot, eList)
head(annualPcts[["flux"]])
head(annualPcts[["conc"]])

}
