% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_for_newer_data.R
\name{search_for_newer_data}
\alias{search_for_newer_data}
\title{Search for newer data}
\usage{
search_for_newer_data(
  archive,
  ...,
  source = path_home("Downloads"),
  target = "data",
  ask = TRUE,
  advice = TRUE
)
}
\arguments{
\item{archive}{TM archive path, giving the project name and date}

\item{...}{unused}

\item{source}{the path vector to be searched, default to both "data" and the usual "Downloads" folder}

\item{target}{the path where files should be copied}

\item{ask}{whether to ask the user to move the file to "data"}

\item{advice}{whether to advice how to move it instead, if \code{ask==FALSE}}
}
\value{
the path to the newer file, invisibly.
}
\description{
Search in some folders if a TrialMaster database more recent than the current extraction is present. By default, it will search the "data" folder and the OS usual "Downloads" folder. If a newer database is found, user will be asked if they want to move it to the "data" folder.
}
\examples{
\dontrun{
  archive = "data/MYPROJECT_ExportTemplate_xxx_SAS_XPORT_2024_06_01_12_00.zip"
  #tm = read_trialmaster(archive)
  search_for_newer_data(archive)
}
}
