% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanity_checks.R
\name{edc_data_warn}
\alias{edc_data_warn}
\alias{edc_data_stop}
\alias{edc_data_warnings}
\alias{assert_no_rows}
\title{Standardized warning system}
\usage{
edc_data_warn(
  df,
  message,
  ...,
  issue_n = "xx",
  max_subjid = 5,
  csv_path = FALSE,
  envir = parent.frame(),
  col_subjid = get_subjid_cols()
)

edc_data_stop(df, message, ..., issue_n, max_subjid, csv_path, envir, col_subjid)

edc_data_warnings()
}
\arguments{
\item{df}{the filtered dataframe}

\item{message}{the message. Can use \href{https://cli.r-lib.org/reference/inline-markup.html#classes}{cli formats}. \code{df} can be accessed using the \code{.data} special keyword (see example)}

\item{...}{unused}

\item{issue_n}{identifying row number}

\item{max_subjid}{max number of subject ID to show in the message}

\item{csv_path}{a path to save \code{df} in a csv file that can be shared with the DM for more details.}

\item{envir}{the environment to evaluate \code{message} in.}

\item{col_subjid}{column name for subject ID. Set to \code{NULL} to ignore.}
}
\value{
\code{df} invisibly
}
\description{
When checking your data, filter your dataset to get only problematic rows. \cr
Then, use either:
\itemize{
\item \code{edc_data_warn()} to generate a standardized warning that can be forwarded to the datamanager.
\item \code{edc_data_stop()} to abort the script if the problem is too serious.
}

Each time \link{edc_data_warn} is used, the warning is saved internally so that a summary of all your warnings can be retrieved using \link{edc_data_warnings}. \cr The result can be saved into an Excel file using \code{\link[=save_edc_data_warnings]{save_edc_data_warnings()}}.
}
\examples{
library(dplyr)
db = edc_example()
load_database(db)
enrol \%>\% 
  filter(age>70) \%>\% 
  edc_data_warn("Age should not be >70", issue_n=1)

enrol \%>\% 
  filter(age<25) \%>\% 
  edc_data_warn("Age should not be <25", issue_n=2)

data1 \%>\% 
  filter(n()>1, .by=subjid) \%>\% 
  edc_data_warn("There are duplicated patients in `data1` ({nrow(.data)} rows)", issue_n=3)

enrol \%>\% 
  filter(age<25) \%>\% 
  edc_data_warn("Age should not be <25", issue_n=NULL)
  
edc_data_warnings()

\dontrun{
enrol \%>\% 
  filter(age<25) \%>\% 
  edc_data_warn("Age should not be <25", csv_path="check/check_age_25.csv")
  
enrol \%>\% 
  filter(age<25) \%>\% 
  edc_data_stop("Age should *never* be <25")
}
}
