\name{CQ2}
\alias{CQ2}
\title{Two-Sample CQ Test for High-Dimensional Covariance Matrices}
\description{
  Performs a two-sample test to compare the covariance matrices of two high-dimensional samples.
  This test is designed for situations where the number of variables \( p \) is large relative to the sample sizes \( n_1 \) and \( n_2 \).
}
\usage{
CQ2(X, Y)
}
\arguments{
  \item{X}{A numeric matrix representing the first sample, where rows are variables and columns are observations.}
  \item{Y}{A numeric matrix representing the second sample, where rows are variables and columns are observations.}
}
\details{
  The test statistic is based on the difference between the sample covariance matrices, normalized by their variances. The p-value is computed using a normal approximation.
}
\value{
  A list containing the following components:
  \item{statistics}{The test statistic \( Q_n \).}
  \item{p.value}{The p-value of the test.}
  \item{alternative}{The alternative hypothesis ("two.sided").}
  \item{method}{The method used ("Two-Sample CQ test").}
}
\examples{
  # Example usage:
  set.seed(123)
  p <- 50
  n1 <- 30
  n2 <- 30
  X <- matrix(rnorm(n1 * p), nrow = p, ncol = n1)
  Y <- matrix(rnorm(n2 * p), nrow = p, ncol = n2)
  result <- CQ2(X, Y)
  print(result)
}