% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_outcome.R
\name{plot_detection_outcome}
\alias{plot_detection_outcome}
\title{plot_detection_outcome}
\usage{
plot_detection_outcome(
  qc_summary,
  target_damage = c(0.1, 0.8),
  palette = c("grey", "#7023FD", "#E60006")
)
}
\arguments{
\item{qc_summary}{A data frame containing the quality control summary for
cells.}

\item{target_damage}{Numeric vector specifying the target damage levels for
color scaling.}

\item{palette}{A character vector specifying the color gradient used for
coloring the damage levels.}
}
\value{
A \code{ggplot2} object representing the scatter plot of quality
control metrics.
}
\description{
Function to generate a plot showing the distribution of quality control
metrics across altered data.
}
\details{
This function visualizes the distribution of features and proportions of
mitochondrial and ribosomal genes for altered cells, coloring the points by
their damage levels. It helps in assessing how well the damage detection
process has classified cells based on their quality control metrics.
}
\keyword{internal}
