% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.optimal_2arm_piecewise.R
\name{get.optimal_2arm_piecewise}
\alias{get.optimal_2arm_piecewise}
\title{Obtain Optimal Design Parameters for DTE-BOP2 Design}
\usage{
get.optimal_2arm_piecewise(
  median.1,
  median.2,
  gprior.E_1 = NULL,
  gprior.E_2 = NULL,
  L,
  U,
  S_likely = (L + U)/2,
  lambda.seq = seq(0.5, 0.975, by = 0.025),
  gamma.seq = seq(0, 1, by = 0.1),
  trunc.para,
  Uniform = FALSE,
  err1,
  nsim,
  n.interim,
  rate,
  FUP,
  track = TRUE,
  control = FALSE,
  control.point = NULL
)
}
\arguments{
\item{median.1}{Numeric. The overall median survival time for the standard-of-care (SOC) arm under the null hypothesis.}

\item{median.2}{Numeric. The overall median survival time for the experimental arm under the alternative hypothesis.}

\item{gprior.E_1}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the pre-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,3/log(2)*median.1)}}

\item{gprior.E_2}{Optional. A numeric vector of length two specifying the shape and scale parameters of the inverse-gamma prior for the post-separation mean survival time (i.e., 1/hazard rate). If NULL, the default is  \code{c(4,6/log(2)*median.1)}}

\item{L}{Numeric. The lower bound of the delayed treatment effect (DTE) separation timepoint.}

\item{U}{Numeric. The upper bound of the delayed treatment effect (DTE) separation timepoint.}

\item{S_likely}{Numeric. The most likely value of the DTE separation timepoint. Defaults to the midpoint of \code{L} and \code{U}.}

\item{lambda.seq}{A vector. The sequence of \eqn{\lambda} in \eqn{1-\lambda(n/N)^{\gamma}}}

\item{gamma.seq}{A vector. The sequence of \eqn{\gamma} in \eqn{1-\lambda(n/N)^{\gamma}}}

\item{trunc.para}{Vector value with two elements. The first element is the shape parameter for the truncated gamma prior and the second one is the scale parameter.}

\item{Uniform}{Logical value.
\itemize{
\item \code{Default} FALSE. The truncated gamma distribution for the separation time will be utilized.
\item \code{If TRUE} the average type I error and power are calculated based on 20 evenly divided points in the interval \eqn{[L,U]}.
}}

\item{err1}{Type I error rate.}

\item{nsim}{Integer. Number of simulations to generate. Default is 10000.}

\item{n.interim}{A vector of sample sizes per arm at each interim analysis.
\itemize{
\item Each element except the last represents an interim sample size per arm.
\item The final element is the total sample size N per arm.
}}

\item{rate}{Numeric value. Patient accrual rate (e.g., patients per month).}

\item{FUP}{Numeric value. Duration of follow-up. Default is 6 month/year in the context.}

\item{track}{Logical value. If true, it will report the current lambda value in the running simulations.}

\item{control}{Logical value. If TRUE, the type I error will be additionally controlled at control point. Default is FALSE.}

\item{control.point}{Vector. It specifies the points where the type I error is controlled.}
}
\value{
A list with the following components:
\describe{
\item{optimal}{A numeric vector of length four. Contains the optimal values of \eqn{\lambda} and \eqn{\gamma},
along with the average type I error and average power achieved under these tuning parameters.}

\item{oc.mat}{A numeric matrix containing all evaluated combinations of \eqn{\lambda} and \eqn{\gamma}
that satisfy the type I error constraint. Each row includes values for \eqn{\lambda}, \eqn{\gamma},
average type I error, and average power.}
}
}
\description{
Computes the optimal tuning parameters \eqn{\lambda} and \eqn{\gamma} for use in posterior decision rules of two-arm, multi-stage survival trials under a piecewise exponential model with delayed treatment effect. These parameters are selected to control the type I error and maximize power, given user-specified interim sample sizes, prior distribution for the delayed separation timepoint, and hypothesized median survival times.
}
\examples{
# Define design and simulation parameters
median.1 <- 6
median.2 <- 10
L <- 2.6
U <- 3.4
S_likely <- 2.7
trunc.para <- c(1, 1)
rate <- 3
FUP <- 9
err1 <- 0.15
n.interim <- c(30, 50)  # Each arm has 30 patients at interim and 50 at final
\donttest{
get.optimal_2arm_piecewise(
  median.1 = median.1,
  median.2 = median.2,
  L = L,
  U = U,
  Uniform = FALSE,
  S_likely = S_likely,
  trunc.para = trunc.para,
  err1 = err1,
  n.interim = n.interim,
  rate = rate,
  FUP = FUP,
  track = TRUE,
  nsim = 10000
)
}
}
