% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRandomMeal.R
\name{createRandomMeal}
\alias{createRandomMeal}
\title{Random meal plan}
\usage{
createRandomMeal(
  foods_df,
  targets_df,
  person,
  diet,
  allowed_varieties,
  min_serve_size_difference,
  allow_discretionary = TRUE,
  allow_alcohol = TRUE,
  allow_takeaway = TRUE,
  emission_cols = NULL,
  nutrient_cols = NULL
)
}
\arguments{
\item{foods_df}{Foods dataframe.}

\item{targets_df}{Nutrient targets dataframe.}

\item{person}{Individual whose random meal plan will be created to. Can be one of man, woman, boy or girl.}

\item{diet}{Chosen diet. Must be DIETNAME from 'constraints_DIETNAME_diet_foods' sheet in dataset.}

\item{allowed_varieties}{Permitted food varieties. Can be a vector of the following: 1,2 and/or 3.}

\item{min_serve_size_difference}{Multiplier to serve difference. A float between 0 and 1.}

\item{allow_discretionary}{Boolean variable checking if discretionary foods are permitted. Default TRUE.}

\item{allow_alcohol}{Boolean variable checking if alcohol is permitted. Default TRUE.}

\item{allow_takeaway}{Boolean variable checking if takeaway is permitted. Default TRUE.}

\item{emission_cols}{Optional parameter. Emission column names if standard dataset isn't used.}

\item{nutrient_cols}{Optional parameter. Nutrients column names if standard dataset isn't used.}
}
\value{
Random meal plan dataframe.
}
\description{
Creates a random meal plan.
}
\examples{
foods_df <- createRandomMeal(foods_df = DIETCOST::foods,
                             targets_df = DIETCOST::nutrient_targets,
                             person = 'man', 
                             diet = 'C', 
                             allowed_varieties = c(1,2,3), 
                             min_serve_size_difference = 0.5, 
                             allow_takeaway = TRUE, 
                             allow_alcohol = TRUE, 
                             allow_discretionary = TRUE)
}
