\name{quantileResiduals}
\alias{quantileResiduals}
\alias{quantileResiduals.DDPstar}
\title{
Quantile residuals.
}
\description{
Produces quantile residuals for objects of class \code{DDPstar} as produced by function \code{DDPstar}.
}
\usage{
\method{quantileResiduals}{DDPstar}(object, parallel = c("no", "multicore", "snow"), 
  ncpus = 1, cl = NULL, ...)
}
\arguments{
  \item{object}{An object of class \code{DDPstar} as produced by function \code{DDPstar}.}
  \item{parallel}{A characters string with the type of parallel operation: either "no" (default), "multicore" (not available on Windows) or "snow".}
  \item{ncpus}{An integer with the number of processes to be used in parallel operation. Defaults to 1.}
  \item{cl}{An object inheriting from class \code{cluster} (from the \code{parallel} package), specifying an optional parallel or snow cluster if parallel = "snow". If not supplied, a cluster on the local machine is created for the duration of the call.}
  \item{\dots}{further arguments passed to or from other methods. Not yet implemented}
}
\details{
Quantile residuals (Dunn and Smyth, 1996) are based on the well-known fact that for a continuous random variable, say \eqn{Y}, with CDF given by \eqn{F}, one has that \eqn{F(Y) \sim U(0,1)}. As a consequence, quantile residuals defined by \eqn{\hat{r}_j = \Phi^{-1}(\hat{F}(y_j))}, \eqn{j = 1, \ldots, n}, should follow, approximately, a standard normal distribution if a correct model has been specified. A quantile-quantile (QQ) plot can then be used to determine deviations of the quantile residuals from the standard normal distribution.
}
\value{
As a result, the function provides a list with the following components:
\item{x}{Theoretical quantiles}
\item{y}{Sample quantiles: posterior mean}
\item{ymin}{Sample quantiles: posterior 0.025 quantile}
\item{ymax}{Sample quantiles: posterior 0.975 quantile}
}
\references{
Dunn, P. K. and Smyth, G. K. (1996). Randomized Quantile Residuals. Journal of Computational and Graphical Statistics, 5(3), 236-244.
}
\seealso{
\code{\link{DDPstar}}
}
\examples{
library(DDPstar)
data(dde)
dde$GAD <- dde$GAD/7 # GAD in weeks
\donttest{
set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
  data = dde, mcmc = list(nburn = 20000, nsave = 15000, nskip = 1), 
  prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
  standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)

qres <- quantileResiduals.DDPstar(fit_dde)

plot(qres$x, qres$y, xlab = "Theoretical Quantiles", ylab = "Sample Quantiles", 
  cex.main = 2, cex.lab = 1.5, cex.axis = 1.5)
lines(qres$x, qres$ymin, lty = 2, lwd = 2)
lines(qres$x, qres$ymax, lty = 2, lwd = 2)
abline(a = 0, b = 1, col ="red", lwd = 2) 

}
\dontshow{
set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
data = dde, mcmc =list(nburn = 20, nsave = 15, nskip = 1), 
prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)

qres <- quantileResiduals.DDPstar(fit_dde)

plot(qres$x, qres$y, xlab = "Theoretical Quantiles", ylab = "Sample Quantiles", 
  cex.main = 2, cex.lab = 1.5, cex.axis = 1.5)
lines(qres$x, qres$ymin, lty = 2, lwd = 2)
lines(qres$x, qres$ymax, lty = 2, lwd = 2)
abline(a = 0, b = 1, col ="red", lwd = 2)
}
}