\name{priorcontrol}
\alias{priorcontrol}
\title{
Prior information for the DDPstar model
}
\description{
This function is used to set various parameters controlling the prior information to be used in the \code{DDPstar} function.
}
\usage{
priorcontrol(m0 = NA, S0 = NA, nu = NA, Psi = NA, 
  atau = 1, btau = 0.005, a = 2, b = NA, alpha.fixed = FALSE, 
  alpha = 1, aalpha = 2, balpha = 2, L = 10)
}
\arguments{
  \item{m0}{A numeric vector. Hyperparameter; mean vector of the (multivariate) normal prior distribution for the parametric coefficients. \code{NA} signals autoinitialization, with defaults: a vector, of length \eqn{Q} (where \eqn{Q} is the number of parametric coefficients), of zeros, if the data are standardised and the least squares estimates of the regression coefficients if the data are not standardised.}
  \item{S0}{A numeric matrix. Hyperparameter; covariance matrix of the (multivariate) normal prior distribution for the parametric coefficients. \code{NA} signals autoinitialization, with defaults: 10\eqn{I_{Q\times Q}} if the data are standardised (where \eqn{Q} is the number of parametric coefficients) and \eqn{\mathbf{\hat{\Sigma}}} if the data are not standardised, where \eqn{\mathbf{\hat{\Sigma}}} is the estimated covariance matrix of the parametric coefficients obtained by fitting a linear model to the data.}
  \item{nu}{A numeric value. Hyperparameter; degrees of freedom of the Wishart prior distribution for the precision matrix associated with the parametric coefficients. \code{NA} signals autoinitialization, with default \eqn{Q+2} (where \eqn{Q} is the number of parametric coefficients)}
  \item{Psi}{A numeric matrix. Hyperparameter; scale matrix of the Wishart prior distribution for the precision matrix associated with the parametric coefficients. \code{NA} signals autoinitialization, with defaults: \eqn{I_{Q\times Q}} if the data are standardised (where \eqn{Q} is the number of parametric coefficients) and to 30\eqn{\mathbf{\hat{\Sigma}}} if the data are not standardised, where \eqn{\mathbf{\hat{\Sigma}}} is the estimated covariance matrix of the parametric coefficients obtained by fitting a linear model to the data.}
  \item{atau}{A numeric value. Hyperparameter; shape parameter of the gamma prior distribution for the precisions (inverse variances) of the smooth/nonlinear/random terms. The default is 1.}
  \item{btau}{A numeric value. Hyperparameter; rate parameter of the gamma prior distribution for the precisions (inverse variances) of the smooth/nonlinear/random terms. The default is 0.005.}
  \item{a}{A numeric value. Hyperparameter; shape parameter of the gamma prior distribution for the precisions (inverse variances) of each component. The default is 2.}
  \item{b}{A numeric value. Hyperparameter; shape parameter of the gamma prior distribution for the precisions (inverse variances) of each component. \code{NA} signals autoinitialization, with defaults: 0.5 if the data are standardised and \eqn{\frac{\hat{\sigma}^2}{2}} if the data are not standardised}
  \item{alpha.fixed}{A logical value. If \code{TRUE}, the precision parameter of the Dirichlet Process is considered fixed. If \code{FALSE}, a Gamma prior distribution is placed on it.}
  \item{alpha}{A numeric value. Applicable when \code{alpha.fixed = TRUE}. Precision parameter of the Dirichlet Process. The default is 1.}
  \item{aalpha}{A numeric value. Applicable when \code{alpha.fixed = FALSE}. Hyperparameter; shape parameter for the Gamma prior distribution of the precision parameter of the Dirichlet process prior. The default is 2.}
  \item{balpha}{A numeric value. Applicable when \code{alpha.fixed = FALSE}. Hyperparameter; rate parameter for the Gamma prior distribution of the precision parameter of the Dirichlet process prior. The default is 2.}
  \item{L}{A numeric value. Upper bound on the number of mixture components. Setting L = 1 corresponds to a normal model. The default is 10.}
}
\value{
A list with components for each of the possible arguments.
}
\seealso{
\code{\link{DDPstar}}
}
\examples{
library(DDPstar)
data(dde)
dde$GAD <- dde$GAD/7 # GAD in weeks
\donttest{
prior <- priorcontrol(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20)

set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
  data = dde, mcmc = list(nburn = 20000, nsave = 15000, nskip = 1), prior = prior, 
  standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE, compute.DIC = TRUE)
summary(fit_dde)
}
\dontshow{
prior <- priorcontrol(a = 1, b = 2, aalpha = 2, balpha = 2, L = 20)

set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
data = dde, mcmc = list(nburn = 20, nsave = 15, nskip = 1), prior = prior, 
standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)
summary(fit_dde)
}
}