% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{csp_cost_segmentation}
\alias{csp_cost_segmentation}
\title{Comparative Shortest Path with cost weighting tree segmentation}
\usage{
csp_cost_segmentation(
  las,
  map,
  Voxel_size = 0.3,
  V_w = 0,
  L_w = 0,
  S_w = 0,
  N_cores = 1
)
}
\arguments{
\item{las}{A lidR LAS S4 object.}

\item{map}{A data.frame, including the columns
X, Y, Z, TreeID, with X and Y depicting the location of the trees. Can be generated using CspStandSegmentation::find_base_coordinates_raster}

\item{Voxel_size}{The voxel size (3D resolution) for the routing graph to
determine the nearest map location for every point in the point cloud.}

\item{V_w}{verticality weight. Since trunks are vertical structures, routing
through voxels with high verticality can be rated 'cheaper.' should be a
number between 0 and 1 with 0 meaning no benefit for more vertical
structures.}

\item{L_w}{Linearity weight. Similar to V_w but for linearity, higher
values indicate a malus for linear shapes (usually branches).}

\item{S_w}{Spericity weight. Similar to V_w but for sphericity, higher
values indicate a malus for spherical shapes (usually small branches and
leaves).}

\item{N_cores}{number of CPU cores used for parallel routing using the
foreach package.}
}
\value{
Returns a copy of the las point cloud with an additional field for
the TreeID.
}
\description{
Segments single trees from forest point clouds based on tree positions
(xyz-coordinates) provided in the map argument.
}
\details{
The whole point cloud is voxelized in the given resolution and the center of
gravity for the points inside is calculated as voxel coordinate. A graph is
build, which connects the voxel coordinates based on a db-scan algorithm. The
distances between the voxel coordinates is weighted based on geometric
features computed for the points in the voxels. Distances along planar
and/or vertical faces like stems are weighted shorter than distances through
voxels with high sphericity like leaves and clusters of twigs. This
avoids small individuals spreading into the upper canopy.
For every voxel center, the weighted distance in the network is calculated to
all tree locations from the map argument. The TreeID of the map argument
with the shortest distance is assigned to the voxel. All points in the point
cloud receive the TreeID from their parent voxel.
}
\examples{

# read example data
\donttest{
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
las = lidR::readTLSLAS(file)

# Find tree positions as starting points for segmentation
map <- CspStandSegmentation::find_base_coordinates_raster(las)

# segment trees
segmented <- las |>
CspStandSegmentation::add_geometry() |>
CspStandSegmentation::csp_cost_segmentation(map, 1, S_w = 0.5)


}

}
\seealso{
\code{\link{comparative_shortest_path}}
}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
