% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossExpression.R
\name{rotate_coordinates}
\alias{rotate_coordinates}
\title{This function takes x and y coordinates and rotates them counterclockwise
by the specified number of degrees, and mean centers the points.}
\usage{
rotate_coordinates(
  x,
  y,
  n_degrees = 0,
  center = FALSE,
  scale = FALSE,
  flip_x = FALSE,
  flip_y = FALSE
)
}
\arguments{
\item{x}{The x coordinates.}

\item{y}{The y coordinates.}

\item{n_degrees}{The degree of rotation in counterclockwise direction.}

\item{center}{If TRUE, mean centers the points.}

\item{scale}{If TRUE, standardizes the points.}

\item{flip_x}{Reflects the points across y = 0 line.}

\item{flip_y}{Reflects the points across x = 0 line.}
}
\value{
Returns a data frame containing the new x and y coordinates.
}
\description{
This function takes x and y coordinates and rotates them counterclockwise
by the specified number of degrees, and mean centers the points.
}
\examples{
data("locations")
locations = as.data.frame(as.matrix(locations))
ggplot2::ggplot(data = locations) + ggplot2::aes(x = pos_x, y = pos_y) +
  ggplot2::geom_point(size = 0) + ggplot2::theme_classic()

locations = rotate_coordinates(x = locations$pos_x, y = locations$pos_y, n_degrees = 45)
ggplot2::ggplot(data = locations) + ggplot2::aes(x = pos_x, y = pos_y) +
  ggplot2::geom_point(size = 0) + ggplot2::theme_classic()

}
