% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_analysis.R
\name{stability_analysis}
\alias{stability_analysis}
\title{Stability Analysis using Eberhart-Russell Model}
\usage{
stability_analysis(
  data,
  genotype_col,
  environment_col,
  replication_col,
  trait_cols
)
}
\arguments{
\item{data}{A data frame containing the dataset with required columns.}

\item{genotype_col}{Character. Name of the genotype column.}

\item{environment_col}{Character. Name of the environment column.}

\item{replication_col}{Character. Name of the replication column.}

\item{trait_cols}{A vector of trait column names (response variables).}
}
\value{
A list containing results for each trait:
\itemize{
  \item `anova`: The ANOVA table for each trait.
  \item `regression`: Regression parameters for stability analysis.
}
}
\description{
This function performs stability analysis for multiple traits across different environments using
Eberhart and Russell's regression model provided by the `metan` package. It computes ANOVA tables
and regression parameters for assessing genotype stability.
}
\examples{
\donttest{
if (!requireNamespace("metan", quietly = TRUE)) {
  install.packages("metan")
}
library(metan)

# Simulated dataset
set.seed(123)
data <- data.frame(
  Genotype = rep(c("G1", "G2", "G3"), each = 12),
  Environment = rep(c("E1", "E2", "E3", "E4"), times = 9),
  Replication = rep(1:3, times = 12),
  Trait1 = c(rnorm(36, 50, 5)),
  Trait2 = c(rnorm(36, 150, 10)),
  Trait3 = c(rnorm(36, 250, 15))
)

results <- stability_analysis(
  data = data,
  genotype_col = "Genotype",
  environment_col = "Environment",
  replication_col = "Replication",
  trait_cols = c("Trait1", "Trait2", "Trait3")
)

print(results$Trait1$anova)
print(results$Trait1$regression)
}
}
\references{
Eberhart, S. A., & Russell, W. A. (1966). "Stability Parameters for Comparing Varieties". 
Crop Science, 6(1), 36–40. doi:10.2135/cropsci1966.0011183X000600010011x
}
