% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdscontrol.R
\name{mdscontrol}
\alias{mdscontrol}
\title{Utility function}
\usage{
mdscontrol(
  model = "ordinal",
  init = "torgerson",
  transf = "primary",
  userinit = NULL,
  w = NULL,
  minstress = 1e-05,
  itermax = 500,
  printscr = TRUE,
  spline.degree = 2,
  spline.intKnots = 2,
  relax = FALSE,
  modulus = 1
)
}
\arguments{
\item{model}{Specifies MDS model. One among "ordnal (default)" or "metric"}

\item{init}{Initial configuration. One among "torgerson" (degault), "random" or "user"}

\item{transf}{The transformation. One among "primary" (default), "secondary","tertiary","spline","ratio","interval","none"}

\item{userinit}{The user initial configuration if "init" has been set as "user"}

\item{w}{The set of weigths. Default: NULL}

\item{minstress}{the minimum stress (for stress method). Default 1e-5}

\item{itermax}{Maximum number if iterations. Default 500}

\item{printscr}{Display the summary of the model. Default TRUE}

\item{spline.degree}{Degree of spline transformation. Default 2}

\item{spline.intKnots}{Interior knots. default 2}

\item{relax}{Relax the solution. Default FALSE}

\item{modulus}{Modulus. Default 1}
}
\value{
A list containing all the control parameters
}
\description{
Utility function to use to set the control arguments of \code{kunfolding}
}
\seealso{
\code{\link{kunfolding}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
