% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2Connectedness.R
\name{R2Connectedness}
\alias{R2Connectedness}
\title{R2 connectedness approach}
\usage{
R2Connectedness(
  x,
  window.size = NULL,
  nlag = 0,
  method = "pearson",
  relative = FALSE,
  corrected = FALSE
)
}
\arguments{
\item{x}{zoo data matrix}

\item{window.size}{Rolling-window size or Bayes Prior sample size}

\item{nlag}{Lag length}

\item{method}{"pearson", "spearman", or "kendall". "pearson" is default.}

\item{relative}{Boolean whether relative or absolute R2 should be used}

\item{corrected}{Boolean value whether corrected or standard TCI should be computed}
}
\value{
Get R2 connectedness measures
}
\description{
This function computes the R2 connectedness measures
}
\examples{
\donttest{
data("dy2012")
dca = R2Connectedness(dy2012, window.size=NULL, nlag=0, method="pearson")
dca$TABLE
}
}
\references{
Naeem, M. A., Chatziantoniou, I., Gabauer, D., & Karim, S. (2023). Measuring the G20 Stock Market Return Transmission Mechanism: Evidence From the R2 Connectedness Approach. International Review of Financial Analysis.

Balli, F., Balli, H. O., Dang, T. H. N., & Gabauer, D. (2023). Contemporaneous and lagged R2 decomposed connectedness approach: New evidence from the energy futures market. Finance Research Letters, 57, 104168.
}
\author{
David Gabauer
}
