% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcTotalHeating.R
\name{calcTotalHeating}
\alias{calcTotalHeating}
\title{Calculate Total Heating}
\usage{
calcTotalHeating(Temp1, Temp2, RH1, RH2, volumeFlowRate)
}
\arguments{
\item{Temp1}{Initial Temperature (°Celsius)}

\item{Temp2}{Final Temperature (°Celsius)}

\item{RH1}{Initial Relative Humidity (0-100\%)}

\item{RH2}{Final Relative Humidity (0-100\%)}

\item{volumeFlowRate}{Volume flow rate of air in cubic meters per second (m³/s)}
}
\value{
Total Heating in kilowatts (kW)
}
\description{
This function calculates total heating power.

Total heating power is the sum of sensible (felt) heat and latent (hidden) heat.
}
\examples{
calcTotalHeating(20, 25, 50, 30, 0.5)



}
\seealso{
\code{\link{calcAD}}, \code{\link{calcEnthalpy}}
}
