% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtLHDs_prime.R
\name{wtLHDs_prime}
\alias{wtLHDs_prime}
\title{Weighted Criteria-Based Latin Hypercube Designs (LHDs) for Prime Numbers}
\usage{
wtLHDs_prime(
  levels,
  factors,
  w1,
  w2,
  w3,
  pop_size = 30,
  generations = 100,
  mut_prob = 1/(factors - 1)
)
}
\arguments{
\item{levels}{Range of levels,L is F<=L<=F^2, where, F is number of factors.}

\item{factors}{Any number of prime factors, F >=3.}

\item{w1}{Weight of maximum absolute correlation. Between 0 to 1. So that w1+w2+w3=1.}

\item{w2}{Weight of Phi_p criterion. Between 0 to 1. So that w1+w2+w3=1.}

\item{w3}{Weight of Maxpro criterion. Between 0 to 1. So that w1+w2+w3=1.}

\item{pop_size}{Default population size is 30.}

\item{generations}{Default number of generations is 100.}

\item{mut_prob}{Mutation probability, by default it is 1/(F-1).}
}
\value{
Generates Latin hypercube designs for a given number of factor-level combinations.
}
\description{
Weighted Criteria-Based Latin Hypercube Designs (LHDs) for Prime Numbers
}
\examples{
\dontrun{
library(CompExpDes)
wtLHDs_prime(9,3,1,0,0)
}
}
