% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Colombia_coffee_tbl_df}
\alias{Colombia_coffee_tbl_df}
\title{Colombian Coffee 2016 Export/Import}
\format{
A tibble with 106 observations and 35 variables:
\describe{
  \item{Classification}{Character string representing the classification of the coffee product.}
  \item{Year}{Numeric value representing the year of the data entry.}
  \item{Period}{Numeric value representing the period of the trade.}
  \item{Period Desc.}{Numeric value representing the period description.}
  \item{Aggregate Level}{Numeric value representing the aggregate level of the trade data.}
  \item{Is Leaf Code}{Numeric value indicating whether the trade involves a leaf product.}
  \item{Trade Flow Code}{Numeric value representing the trade flow code.}
  \item{Trade Flow}{Character string representing the flow of the trade, either export or import.}
  \item{Reporter Code}{Numeric value representing the code of the reporting country.}
  \item{Reporter}{Character string representing the reporting country.}
  \item{Reporter ISO}{Character string representing the ISO code of the reporting country.}
  \item{Partner Code}{Numeric value representing the code of the partner country.}
  \item{Partner}{Character string representing the partner country.}
  \item{Partner ISO}{Character string representing the ISO code of the partner country.}
  \item{2nd Partner Code}{Logical value indicating if there is a second partner country involved in the trade.}
  \item{2nd Partner}{Logical value indicating if there is a second partner country.}
  \item{2nd Partner ISO}{Logical value indicating if there is a second partner country's ISO code.}
  \item{Customs Proc. Code}{Logical value representing the customs procedure code.}
  \item{Customs}{Logical value indicating whether customs procedure information is available.}
  \item{Mode of Transport Code}{Logical value representing the mode of transport code.}
  \item{Mode of Transport}{Logical value indicating the mode of transport used in the trade.}
  \item{Commodity Code}{Character string representing the commodity code for coffee.}
  \item{Commodity}{Character string representing the commodity (coffee).}
  \item{Qty Unit Code}{Numeric value representing the quantity unit code.}
  \item{Qty Unit}{Character string representing the unit of quantity for the trade.}
  \item{Qty}{Logical value representing the quantity of coffee in the trade.}
  \item{Alt Qty Unit Code}{Logical value representing an alternative quantity unit code.}
  \item{Alt Qty Unit}{Numeric value representing an alternative quantity unit for the trade.}
  \item{Alt Qty}{Logical value representing an alternative quantity for the trade.}
  \item{Netweight (kg)}{Numeric value representing the net weight of the coffee in kilograms.}
  \item{Gross weight (kg)}{Logical value indicating the gross weight of the coffee in kilograms.}
  \item{Trade Value (US)}{Numeric value representing the trade value in US dollars.}
  \item{CIF Trade Value (US)}{Logical value representing the CIF trade value in US dollars.}
  \item{FOB Trade Value (US)}{Logical value representing the FOB trade value in US dollars.}
  \item{Flag}{Numeric value representing a flag for the dataset entry.}
}
}
\source{
Originally taken from Kaggle, url: https://www.kaggle.com/datasets/carlosbeltranv/colombian-coffee-2016
}
\usage{
data(Colombia_coffee_tbl_df)
}
\description{
This dataset, Colombia_coffee_tbl_df, is a tibble containing detailed information about Colombian coffee exports and imports in 2016.
It includes data on various factors such as trade flow, commodity codes, trade value, weight in kilograms, and information about the
countries involved in the trade. The dataset is sourced from Kaggle and provides a comprehensive analysis of the foreign trade of Colombian coffee.
}
\details{
The dataset name has been kept as Colombia_coffee_tbl_df to avoid confusion with other datasets in the R ecosystem. This naming convention helps
distinguish this dataset as part of the ColombiAPI package and assists users in identifying its specific characteristics. The suffix 'tbl_df' indicates that the dataset is a tibble.
The original content has not been modified in any way.
}
