% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{cleanet}
\alias{cleanet}
\title{Detect doublets in a single cytometry sample}
\usage{
cleanet(df, cols, cofactor, thresh = 5, is_debris = NULL)
}
\arguments{
\item{df}{A data frame containing protein expression data.}

\item{cols}{Columns to use in analysis.}

\item{cofactor}{Parameter of arcsinh transformation, applied before
computing nearest neighbors. Recommended values are 5 for mass cytometry
and 500-1000 for flow cytometry.}

\item{thresh}{Among the 15 nearest neighbors, how many should be simulated
doublets in order for the event to be classified as doublet?}

\item{is_debris}{Optional, binary array with length matching
the number of rows in df. TRUE for debris events, FALSE for everything else.
This package includes helper functions to compute this for flow or
mass cytometry data.}
}
\value{
A list with multiple elements, among them the singlet/doublet
status of each event.
}
\description{
Augments data with simulated doublets, computes
nearest neighbors for augmented dataset, identifies doublets as those
events with a high share of simulated doublets among nearest neighbors.
}
\examples{
path <- system.file("extdata", "df_mdipa.csv", package="Cleanet")
df_mdipa <- read.csv(path, check.names=FALSE)
cols <- c("CD45", "CD123", "CD19", "CD11c", "CD16",
          "CD56", "CD294", "CD14", "CD3", "CD20",
          "CD66b", "CD38", "HLA-DR", "CD45RA",
          "DNA1", "DNA2")
cleanet_res <- cleanet(df_mdipa, cols, cofactor=5)
}
