% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenzcurve.R
\name{lorenzcurve}
\alias{lorenzcurve}
\title{The Lorenz curve}
\usage{
lorenzcurve(E, d, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rules}{The rules: AA, APRO, CE, CEA, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{col}{The colours. If \code{col=NULL} then the sequence of default colors is:
c("red", "blue", "green", "yellow", "pink", "orange", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The colour legend is shown if \code{legend=TRUE}.}
}
\value{
The graphical representation of the Lorenz curve of a rule (or several rules) for a claims problem.
}
\description{
This function returns the Lorenz curve of any rule for a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}.
The Lorenz curve represents the proportion of the awards given to each subset of claimants by a specific rule \eqn{\mathcal{R}}  as a function of the
cumulative distribution of population.

The Lorenz curve of a rule \eqn{\mathcal{R}} for the claims problem \eqn{(E,d)} is the polygonal path connecting the \eqn{n+1} points,
\deqn{(0,0), \Bigl(\frac{1}{n},\frac{\mathcal{R}_1(E,d)}{E}\Bigr),\dots,\Bigl(\frac{n-1}{n},\frac{\sum_{i=1}^{n-1}\mathcal{R}_i(E,d)}{E}\Bigl),(1,1).}
Basically, it represents the cumulative percentage of the endowment assigned by the rule to each cumulative percentage of claimants.
}
\examples{
E=10
d=c(2,4,7,8)
Rules=c(AA,RA,Talmud,CEA,CEL)
col=c("red","blue","green","yellow","pink")
lorenzcurve(E,d,Rules,col)
}
\references{
Lorenz, M. O. (1905). Methods of measuring the concentration of wealth. Publications of the American statistical association 9(70), 209-219.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2023a). Deviation from proportionality and Lorenz-domination for claims problems. Review of Economic Design 27, 439-467.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2023b). Refining the Lorenz‐ranking of rules for
claims problems on restricted domains. International Journal of Economic Theory 19(3), 526-558.
}
\seealso{
\link{cumawardscurve}, \link{deviationindex}, \link{giniindex}, \link{indexgpath}, \link{lorenzdominance}.
}
