% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allrules.R
\name{allrules}
\alias{allrules}
\title{Summary of the division rules}
\usage{
allrules(E, d, draw = TRUE, col = NULL)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{draw}{A logical value.}

\item{col}{The colours (useful only if \code{draw=TRUE}). If \code{col=NULL} then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink", "orange", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet","darkgreen").}
}
\value{
A data-frame with the awards vectors selected by the main division rules. If \code{draw = TRUE}, it
displays a mosaic plot representing the data-frame.
}
\description{
This function returns the awards vectors selected, for a given claims problem, by the rules:  AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, and RTalmud.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

A vector \eqn{x=(x_1,\dots,x_n)} is an awards vector for the claims problem \eqn{(E,d)} if \eqn{0\le x \le d}
and satisfies the balance requirement, that is, \eqn{\sum_{i=1}^{n}x_i=E}.

A rule is a function that assigns to each claims problem \eqn{(E,d)} an awards vector.
The formal definitions of the main rules are given in the corresponding function help.
}
\examples{
E=10
d=c(2,4,7,8)
allrules(E,d)
}
\references{
Mirás Calvo, M.A., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2022). The average-of-awards rule for claims problems. Social Choice and Welfare 59, 863-888.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{AA}, \link{APRO}, \link{axioms}, \link{CD}, \link{CE}, \link{CEA}, \link{CEL}, \link{AV}, \link{DT}, \link{MO}, \link{PIN}, \link{PRO},  \link{RA},  \link{Talmud}, \link{RTalmud}, \link{verticalruleplot}.
}
