% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CD.R
\name{CD}
\alias{CD}
\title{Concede-and-divide rule}
\usage{
CD(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of two claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the CD rule. If \code{name = TRUE}, the name of the function (CD) as a character string.
}
\description{
This function returns the awards vector assigned by the concede-and-divide (CD) rule to a two-claimant problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d=(d_1,d_2)\in \mathbb{R}_+^2}
 the vector of claims such that  \eqn{d_1+d_2 \ge E}.

The concede-and-divide rule (CD) first assigns to each of the two claimants the difference between the endowment and the other agent’s claim (or 0 if this
difference is negative), and divides the remainder equally. That is, for each \eqn{i\in \{1,2\}},
\deqn{\text{CD}_i(E,d)=\max\{E-d_j,0\}+\frac{E-\max\{E-d_i,0\}-\max\{E-d_j,0\}}{2}.}
Several rules are extensions of the concede-and-divide rule to general populations: AA, APRO, MO, RA, and Talmud.
}
\examples{
E=10
d=c(7,8)
CD(E,d)
# Talmud, RA, MO, APRO, and AA coincide with CD for two-claimant problems
Talmud(E,d)
RA(E,d)
MO(E,d)
APRO(E,d)
AA(E,d)
}
\references{
Aumann, R. and Maschler, M., (1985). Game theoretic analysis of a bankruptcy problem from the Talmud. Journal of Economic Theory 36, 195–213.

Mirás Calvo,M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez,E. (2025). On how the rules that extend the concede-and-divide principle
differ for pairs of claimants. Preprint.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{AA}, \link{APRO}, \link{MO}, \link{pathawards}, \link{RA}, \link{Talmud}.
}
