\name{axialnntsloglik}
\alias{axialnntsloglik}
\title{
Axial NNTS log-likelihood function
}
\description{
Computes the log-likelihood function with NNTS density for axial data}
\usage{
axialnntsloglik(data, cpars = 1/sqrt(pi), M = 0)
}
\arguments{
  \item{data}{Vector of size R with observed axial angles in radians}
  \item{cpars}{Vector of complex numbers of dimension M+1. The first element is a real and positive number. The sum of the squared moduli of the c parameters must be equal to 1/pi}
  \item{M}{Number of components in the NNTS axial model}
}

\value{
\item{y}{The function returns a 1 by R matrix with the value of the log-likelihood function for each element of the data vector of size R}
}
\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez
}
\references{
Fernandez-Duran, J.J. and Gregorio-Dominguez, M.M. (2025). Multimodal distributions for circular axial data. arXiv:2504.04681 [stat.ME] (available at https://arxiv.org/abs/2504.04681)
}
\examples{
a<-c(runif(10,3*pi/4,pi-0.00000001),runif(10,pi/4,pi/2-0.00000001))
set.seed(12345)
ccoef<-axialnntsrandominitial(2)
axialnntsloglik(a,ccoef,2)
}
