% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{health_family_life_df}
\alias{health_family_life_df}
\title{Chinese Health and Family Life Survey}
\format{
A data frame with 1,534 observations and 10 variables:
\describe{
  \item{R_region}{Region of respondent (factor with 6 levels)}
  \item{R_age}{Age of respondent (numeric)}
  \item{R_edu}{Education level of respondent (ordered factor with 6 levels)}
  \item{R_income}{Income of respondent (numeric)}
  \item{R_health}{Self-reported health status of respondent (ordered factor with 5 levels)}
  \item{R_height}{Height of respondent (numeric)}
  \item{R_happy}{Self-reported happiness level of respondent (ordered factor with 4 levels)}
  \item{A_height}{Height of respondent’s partner (numeric)}
  \item{A_edu}{Education level of respondent’s partner (ordered factor with 6 levels)}
  \item{A_income}{Income of respondent’s partner (numeric)}
}
}
\source{
Data taken from the HSAUR3 package version 1.0-15
}
\usage{
data(health_family_life_df)
}
\description{
This dataset, health_family_life_df, is a data frame from the Chinese Health and Family Life Survey,
which sampled 60 villages and urban neighborhoods to represent the full geographical and socioeconomic
range of contemporary China. The dataset includes 1,534 observations and covers variables related to
age, education, income, health, and well-being, both for respondents and their partners.
}
\details{
The dataset name has been kept as 'health_family_life_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChinAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
