% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggNlme.R
\name{nlme.par.vs.cov}
\alias{nlme.par.vs.cov}
\title{Plot parameter estimates against covariates}
\usage{
nlme.par.vs.cov(xpdb, covColNames, nrow = 1, ncol = 1, ...)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{covColNames}{Character vector of covariates to build the matrix.}

\item{nrow}{Number of rows.}

\item{ncol}{Number of columns; if ncol=1, each gtable object is treated separately.}

\item{...}{Parameters to be passed to \code{\link[egg]{ggarrange}()}.}
}
\value{
List of \code{\link[gtable]{gtable}}
}
\description{
Use to create a stack of plots of parameter estimates plotted against covariates.
}
\examples{
nlme.par.vs.cov(
  xpdb = xpdb_ex_Nlme,
  covColNames = c("sex", "wt", "age")
)

}
