#' @importFrom magrittr %>%
#' @importFrom rlang .data
.load_convergenceData <-
  function(ConvergenceData, dir = NULL, progresstxt = NULL, method, problem = 1) {
    if (!is.null(ConvergenceData)) {
      ConvergenceDataWide <-
        stats::reshape(
          as.data.frame(ConvergenceData),
          timevar = "Parameter",
          idvar = "Iter",
          direction = "wide",
          varying = list(unique(ConvergenceData$Parameter)),
          drop = "Scenario"
        ) %>%
        tibble::tibble()

      colnames(ConvergenceDataWide)[colnames(ConvergenceDataWide) == "Iter"] <-
        "ITERATION"


      ConvergenceDF <- tibble::tibble(
        name = "ConvergenceData",
        extension = "ext",
        problem = problem,
        subprob = 0,
        method = method,
        data = list(ConvergenceDataWide),
        modified = FALSE
      )
    } else {
      progresstxt <- .check_filePath(progresstxt, dir, stopErr = FALSE)
      if (file.exists(progresstxt)) {
        ConvergenceDF <- tibble::tibble(
          name = "ConvergenceData",
          extension = "ext",
          problem = problem,
          subprob = 0,
          method = method,
          data = list(.read_progressFile(progresstxt)),
          modified = FALSE
        )
      } else {
        ConvergenceDF <- tibble::tibble(
          name = "ConvergenceData",
          extension = "ext",
          problem = problem,
          subprob = 0,
          method = method,
          data = list(),
          modified = FALSE
        )
      }
    }

    ConvergenceDF
  }
