#' List of xpose data objects from NONMEM model output
#'
#' The following object contains of list of 2 \code{xpose_data} objects:
#'
#' \itemize{
#'  \item{
#'  \code{xpdb_NONMEM$ex_pk} is an \code{xpose_data} object from \code{xpose::xpdb_ex_pk}. The model contains multiple
#'  covariates and can be used to explore covariate model diagnostics.}
#'   \item{
#'   \code{xpdb_NONMEM$mult_obs} is an \code{xpose_data} object created from NONMEM model with multiple observed variables.
#'   Users will see that appropriate model diagnostic plots are automatically facetted by \code{DVID}
#'   in the Shiny GUI.}
#'  }
#'
#' @format List of 2 \code{xpose_data} objects constructed from NONMEM model output.
#'
#' @source Certara
"xpdb_NONMEM"


#' List of xpose data objects from RsNLME example tutorials
#'
#' The following object contains a list of 2 \code{xpose_data} objects generated in the RsNLME example script
#' \code{TwoCptIVBolus_FitBaseModel_CovariateSearch_VPC_BootStrapping.R}.
#'
#' \itemize{
#'  \item{
#'  \code{xpdb_NLME$`TwCpt_IVBolus_FOCE-ELS`} is an \code{xpose_data} object created from the base model in RsNLME example script.
#'  The model can be used as a reference to compare model diagnostics in final model.}
#'   \item{
#'   \code{xpdb_NLME$`TwCpt_IVBolus_SelectedCovariateModel_FOCE-ELS`} is an \code{xpose_data} object created from the final model
#'   in the RsNLME example script. The final model includes selected covariate \code{BodyWeight} added from the results of
#'   stepwise covariate search.}
#'  }
#'
#' @format List of 2 \code{xpose_data} objects constructed from NLME model output.
#'
#' @source Certara
"xpdb_NLME"
