% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darwin_report_ui.R
\name{darwinReportUI}
\alias{darwinReportUI}
\title{Generate and Report Model Diagnostics from NLME or NONMEM runs}
\usage{
darwinReportUI(darwin_data, tagged = NULL, settings = NULL, ...)
}
\arguments{
\item{darwin_data}{Object of class \code{darwin_data}. Note, key_models xpose_data must be available.}

\item{tagged}{List of tagged objects returned from previous \code{tagged <- darwinReportUI()} session.}

\item{settings}{List of settings (e.g., settings.Rds) returned from previous Shiny session.}

\item{...}{Additional arguments for Pirana integration.}
}
\value{
If \code{interactive()}, returns a list of tagged diagnostics from the Shiny application, otherwise returns \code{TRUE}.
}
\description{
Shiny application to generate, customize, and report diagnostic plots and tables from NLME or
NONMEM output files. Create an Rmarkdown file of tagged model diagnostics and render into
submission ready report.
}
\examples{
if (interactive()) {
ddb <- darwin_data("./darwin_search_09") |>
   import_key_models("./darwin_search_09/key_models")

darwinReportUI(ddb)
}

}
