% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_RRi_fit.R
\name{summary.RRi_fit}
\alias{summary.RRi_fit}
\title{Summary method for RRi_fit objects}
\usage{
\method{summary}{RRi_fit}(object, ...)
}
\arguments{
\item{object}{An object of class "RRi_fit".}

\item{...}{Additional arguments (unused).}
}
\value{
A list with the following components:
\item{method}{The optimization method used.}
\item{parameters}{The estimated parameters from the model.}
\item{objective_value}{The final value of the objective (Huber loss) function.}
\item{convergence}{An integer code indicating convergence (0 indicates success).}
\item{RSS}{Residual sum of squares.}
\item{TSS}{Total sum of squares of the observed RRi values.}
\item{R_squared}{Coefficient of determination.}
\item{n}{The number of observations used.}
}
\description{
Provides a detailed summary of the fitted dual-logistic model, including
measures of fit such as the residual sum of squares (RSS), total sum of squares (TSS),
and R-squared. The summary also includes basic information about the optimization.
}
